getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

# tempdir()
# dir.create(tempdir())
load("c2-setting.RData")


data <- readMat("data2.mat")$data

data.inx <- data[,1:3]
data.x <- data[,4:7]
data.y <- data[,8]

dim.f = c(5,4,4)
d = 4; lower.x = apply(data.x,2,min); upper.x = apply(data.x,2,max)

dim.s = c(2,2,2)
dim.h = prod(dim.s); dim.mode = length(dim.s)

k = 1; N = nrow(data.x)

h <- function(y) sum(y)
true.model<-function(y) sum(sort(y, decreasing = TRUE)[1:k])

y0 = array(NA, c(dim.f,N))
for(i in 1:N) y0[data.inx[i,1],data.inx[i,2],data.inx[i,3],i] = data.y[i]

ind.x.star = which.max(apply(y0,dim.mode+1,true.model))
h.star = apply(y0,dim.mode+1,true.model)[ind.x.star]
ind.star = arrayInd(order(y0[,,,ind.x.star], decreasing = TRUE)[1:k],dim.f)
ora.x.star = data.x[ind.x.star,]

ind.x.star; h.star; ind.star



## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

B.tuck.smt <- function(y,ind,n){
  y_0 = array(NA,dim=c(dim.f,n))
  
  for (i in 1:n) {
    for(j in 1:k){
      idx <- ind[[i]]
      y_0[idx[j,1],idx[j,2],idx[j,3],i] = y[j,i]
    }
  }
  
  tuck.re = multiway::tucker(y_0, nfac = c(dim.s,n), nstart = 1, Dfixed = diag(n))
  U.tuck = list(tuck.re$C,tuck.re$B,tuck.re$A)
  core.ten = tuck.re$G
  
  return(list(core.ten=core.ten, U.tuck=U.tuck))
}
# B.tuck.to(y,k.ind,n)

pos <- function(ind) array(1:prod(dim.f),dim.f)[ind]

e.ind <- function(ind){
  e0 = pos(ind); ord = cbind(1:k,e0)
  e.re = matrix(0,k,prod(dim.f))
  e.re[ord] = 1
  return(e.re)
}


################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-TOGP
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]+1)/2
}
vec.lab[[dim.mode+1]] = d
vec.lab[[dim.mode+2]] = vec.lab[[dim.mode+3]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.smt = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-1,dim.mode),1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(rep(1,dim.mode),10,10,1e-2), unlist(vec.lab))))

sig.smt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = TRUE)] <- ome
  return(O)
}

ker.smt <- function(y,ind,n,the){
  the0 = split(the, group.lab)
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]])
  
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  sig.tuck = Map(function(B) B%*%t(B), sig)
  return(Reduce(kronecker,sig.tuck))
}


likeli.smt <- function(x1,x2,y,ind,n,the){
  the0 = split(the, group.lab); th = the0[[dim.mode+1]]
  sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  omega = ker.smt(y,ind,n,the)
  k.ini = kronecker(ker.sele(x1,x2,th,mat0),omega)
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck)))
  par.k.ini = e.ini%*%k.ini%*%t(e.ini)
  
  log.likeli = determinant(sig2*par.k.ini+tau2*diag(n*k),logarithm=TRUE)$modulus+
    t(c(y))%*%solve(sig2*par.k.ini+tau2*diag(n*k))%*%c(y)
  return(list(like=log.likeli, the0=the0))
}

EIJ <- function(i,j,l){
  E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,ind,n,the){
  the0 = split(the, group.lab)
  
  ome = list()
  for(i in 1:dim.mode){ome[[i]] = the0[[i]]}
  
  th = the0[[dim.mode+1]]; sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  J <- function(i,l){
    E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,i] = exp(sig.smt(dim.s[l],ome[[l]])[i,i])
    return(E0)
  }
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],ome[[i]])
  
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  sig.tuck = Map(function(B) B%*%t(B), sig)
  omega = Reduce(kronecker,sig.tuck)
  
  k.ini = ker.sele(x1,x2,th,mat0)
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck)))
  al.k1 = e.ini%*%kronecker(k.ini,omega)%*%t(e.ini)
  
  par.k.y = sig2*al.k1+tau2*diag(n*k)
  sol.par.k.y = solve(par.k.y)
  
  al.k = sol.par.k.y%*%c(y)
  der.l.sig2 = tr(sol.par.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.par.k.y)-t(al.k)%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(tr(sol.par.k.y%*%e.ini%*%kronecker(der,omega)%*%t(e.ini))-
                                      t(al.k)%*%e.ini%*%kronecker(der,omega)%*%t(e.ini)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  der.l.phi = list()
  for(l in 1:dim.mode){
    der.l.phi[[l]] = matrix(0, dim.s[l], dim.s[l])
    
    der.l.phi.ij <- function(i,j) EIJ(i,j,l)%*%t(sig[[l]])+sig[[l]]%*%EIJ(j,i,l)
    it1 <- function(der.p){
      list1 = if (l > 1) sig.tuck[1:(l-1)] else 1
      list2 = if (l < dim.mode) sig.tuck[(l+1):dim.mode] else 1
      kro.list = list(sig2*k.ini,Reduce(kronecker,list1),der.p,Reduce(kronecker,list2))
      return(Reduce(kronecker,kro.list))
    } 
    it2 <- function(der.p) tr(sol.par.k.y%*%e.ini%*%it1(der.p)%*%t(e.ini))-
      t(al.k)%*%e.ini%*%it1(der.p)%*%t(e.ini)%*%al.k
    
    der.l.phi.1 = sapply(c(1:dim.s[l]), function(i) {
      sapply(c(1:i), function(j) it2(der.l.phi.ij(i, j)))
    })
    
    der.l.phi.ii <- function(i) J(i,l)%*%t(sig[[l]])+sig[[l]]%*%J(i,l)
    der.l.phi.dig = apply(as.matrix(c(1:dim.s[l])),1, function(i) it2(der.l.phi.ii(i)))
    
    for (i in 1:dim.s[l]) {
      der.l.phi[[l]][i, 1:i] <- der.l.phi.1[[i]]
    }
    # diag(der.l.phi[[l]]) = der.l.phi.dig   
  }
  
  result = list(der.l.phi=lapply(der.l.phi, function(mat) mat[lower.tri(mat, diag = TRUE)]), 
                der.l.th=der.l.th, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}
# der.l(x,x,y,k.ind,n,s1,s2,s3,runif(dim.hyper.smt))

smtgp.hat <- function(x.new,ind.new,x,y,ind,n,n.test,hy){
  th = hy[[dim.mode+1]]
  sig2 = hy[[dim.mode+2]]; tau2 = hy[[dim.mode+3]]
  
  x.new = matrix(x.new,n.test,d)
  omega = ker.smt(y,ind,n,unlist(hy))
  
  e.ini = as.matrix(bdiag(lapply(ind,function(ind) e.ind(ind)%*%B.tuck)))
  k.smt.s0 = kronecker(ker.sele(x,x,th,mat0),omega)
  k.smt.s = sig2*e.ini%*%k.smt.s0%*%t(e.ini)+tau2*diag(n*k)
  
  k.smt.10 = ker.sele(x.new,x,th,mat0)
  k.smt.1 = sig2*kronecker(k.smt.10,omega)%*%t(e.ini)
  
  k.smt.00 = ker.sele(x.new,x.new,th,mat0)
  k.smt.0 = sig2*kronecker(k.smt.00,omega)
  
  k.oth = k.smt.1%*%solve(k.smt.s)
  
  f.hat.tuck = k.oth%*%c(y)
  var.hat.tuck = k.smt.0-k.oth%*%t(k.smt.1)
  
  result = list(mean.tuck = f.hat.tuck, cov.tuck = var.hat.tuck)
  return(result)
}


################################################################################
## Our proposed method: NS-TOGP-UCB
n = 5; m = 20; J.for = 10

like.re.smt = hyper.smt = fhat = lapply(1:J.for, function(x) list())
x0.smt = y0.smt = ind.x.smt = ind0.smt = list()
smtgp.bo = h.smt = list()
regret.smt = ins.regret.smt = cum.regret.smt = list()
beta.smt = alpha.smt = ucb.new.smt = lapply(1:J.for, function(x) list())
tab.ind.smt = lapply(1:J.for, function(x) list())



# j.for.smt = 1
for(j.for.smt in 1:J.for){
  
  ind.x = c.ini.set$ind.x.for.new[[j.for.smt]]
  x = data.x[ind.x,]; y.or = y0[,,,ind.x]
  
  k.ind = lapply(1:n, function(i) matrix(data.inx[ind.x[i],],k,dim.mode))
  y.x = alply(y.or, .margins = dim.mode+1)
  y = matrix(sapply(1:n,function(i) 
    y.or[k.ind[[i]][1],k.ind[[i]][2],k.ind[[i]][3],i]),k,n)
  
  y.tuck = B.tuck.smt(y,k.ind,n); B.tuck = Reduce(kronecker,y.tuck$U.tuck)
  
  
  ## Setting
  ######################################## BO ####################################
  hyper.smt.old = directL(function(the) likeli.smt(x,x,y,k.ind,n,the)$like,
                          lower.th,upper.th,control=list(maxeval=1000))$par
  hyper.smt.new = optim(par = hyper.smt.old,
                        fn = function(the) likeli.smt(x,x,y,k.ind,n,the)$like,
                        gr = function(the) unlist(der.l(x,x,y,k.ind,n,the)),
                        method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  
  like.re.smt[[j.for.smt]][[1]] = likeli.smt(x,x,y,k.ind,n,hyper.smt.new)
  hyper.smt[[j.for.smt]][[1]] = like.re.smt[[j.for.smt]][[1]]$the0
  
  x0 = data.x; inx0 = c(1:N)
  x0.smt[[j.for.smt]] = x; y0.smt[[j.for.smt]] = y; ind.x.smt[[j.for.smt]] = ind.x
  n.smt = n; ind0.smt[[j.for.smt]] = k.ind
  
  x.new.smt = t(as.matrix(x[which.max(apply(y,2,h)),]))
  y.new.smt = y[,which.max(apply(y,2,h))]
  ind.new.smt = list(k.ind[[which.max(apply(y,2,h))]])
  e.new = as.matrix(bdiag(lapply(ind.new.smt,function(ind) e.ind(ind)%*%B.tuck)))
  
  hyper.smt.ucb = unlist(hyper.smt[[j.for.smt]][[1]]); delta.smt = 0.05
  fhat[[j.for.smt]][[1]] = smtgp.hat(x.new.smt,ind.new.smt,x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],
                                     ind0.smt[[j.for.smt]],n.smt,1,hyper.smt[[j.for.smt]][[1]])
  
  for(i.smt in 1:m){
    ind.x.new.smt = sample(inx0[-ind.x.smt[[j.for.smt]]],1) #which(apply(x0, 1, function(row) all(row == x0[-ind.x.smt[[j.for.smt]],][which.min(ucb.x),])))[1]
    x.new.smt = x0[ind.x.new.smt,]; y.new.smt.0 = y0[,,,ind.x.new.smt]
    
    smt.output = smtgp.hat(x.new.smt,ind.new.smt,x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,n.test=1,
                           hyper.smt[[j.for.smt]][[i.smt]])
    # ucb.new.smt.cmab = array(e.new%*%smt.output$mean.tuck + sqrt(alpha.smt[[j.for.smt]][[i.smt]])*sqrt(diag(e.new%*%smt.output$cov.tuck%*%t(e.new))), dim.f)
    # ind.new.smt = list(arrayInd(order(ucb.new.smt.cmab, decreasing = TRUE)[1:k],dim.f))
    ind.new.smt = list(t(as.matrix(data.inx[ind.x.new.smt,])))
    e.new = e.ind(ind.new.smt[[1]])%*%B.tuck
    y.new.smt = y.new.smt.0[ind.new.smt[[1]]]
    
    fhat[[j.for.smt]][[i.smt+1]] = smtgp.hat(x.new.smt,ind.new.smt,x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],
                                             n.smt,n.test=1,hyper.smt[[j.for.smt]][[i.smt]])
    
    x0.smt[[j.for.smt]] = rbind(x0.smt[[j.for.smt]], x.new.smt)
    y0.smt[[j.for.smt]] = cbind(y0.smt[[j.for.smt]], y.new.smt)
    ind.x.smt[[j.for.smt]] = c(ind.x.smt[[j.for.smt]],ind.x.new.smt)
    
    ind0.smt[[j.for.smt]] = append(ind0.smt[[j.for.smt]], ind.new.smt)
    
    n.smt = n+i.smt
    
    if(i.smt %% 50 == 0){
      hyper.smt.ucb = optim(par = unlist(hyper.smt[[j.for.smt]][[i.smt]]), 
                            fn = function(the) likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,the)$like,
                            gr = function(the) unlist(der.l(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,the)), 
                            method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.smt.ucb = hyper.smt.ucb
    }
    
    hyper.smt.ucb = runif(dim.hyper.smt,lower.th,upper.th)
    like.re.smt[[j.for.smt]][[i.smt+1]] = likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],n.smt,hyper.smt.ucb)
    hyper.smt[[j.for.smt]][[i.smt+1]] = like.re.smt[[j.for.smt]][[i.smt+1]]$the0
    print(i.smt)
  }
  smtgp.ucb <- function(x.new,ind.new) smtgp.hat(x.new,ind.new,x0.smt[[j.for.smt]],y0.smt[[j.for.smt]],ind0.smt[[j.for.smt]],
                                                 n.smt,n.test=1,hyper.smt[[j.for.smt]][[i.smt+1]]) 
  smtgp.bo[[j.for.smt]] = smtgp.ucb
  
  h.smt[[j.for.smt]] = apply(y0.smt[[j.for.smt]],2,h)
  regret.smt[[j.for.smt]] = h.star-h.smt[[j.for.smt]]
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.smt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.smt[[j.for.smt]])[n],h.star))
  lines(cummax(h.smt[[j.for.smt]])[n:n.smt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  ins.regret.smt[[j.for.smt]] = h.star-cummax(h.smt[[j.for.smt]][(n+1):n.smt])
  cum.regret.smt[[j.for.smt]] = cumsum(ins.regret.smt[[j.for.smt]])
  
  plot(cumsum(ins.regret.smt[[j.for.smt]]),type="b",lwd=3,lty=2,pch=2,col=2)
  
  
  tab.ind.smt[[j.for.smt]] = unlist(lapply(ind0.smt[[j.for.smt]],
                                           function(a) sum(apply(a, 1, function(row) any(duplicated(rbind(row, ind.star)))))))
  tab.ind.smt[[j.for.smt]][which.max(h.smt[[j.for.smt]])]
  print(j.for.smt)
}



mat <- do.call(rbind, cum.regret.smt)
cum.regret.mean <- apply(mat,2, mean)
cum.regret.lower <- apply(mat,2, function(x) quantile(x, 0.025))
cum.regret.upper <- apply(mat,2, function(x) quantile(x, 0.975))


time <- 1:m
plot(time, cum.regret.mean, type = "l", lwd = 2, col = "blue", ylim = range(c(cum.regret.lower, cum.regret.upper)),
     ylab = "Value", xlab = "Time", main = "Mean with 95% Confidence Band")
polygon(c(time, rev(time)),
        c(cum.regret.upper, rev(cum.regret.lower)),
        col = rgb(0.1, 0.2, 0.9, 0.2), border = NA)
lines(time, cum.regret.mean, col = "blue", lwd = 2)


psmt.rs.list = list(ind.x.star=ind.x.star, h.star=h.star, ind.star=ind.star, ora.x.star=ora.x.star,         
                     like.re.smt=like.re.smt, hyper.smt=hyper.smt, fhat=fhat,
                     x0.smt=x0.smt, y0.smt=y0.smt, smtgp.bo=smtgp.bo, 
                     h.smt=h.smt, regret.smt=regret.smt, ins.regret.smt=ins.regret.smt, cum.regret.smt=cum.regret.smt,
                     ind.x.smt=ind.x.smt, ind0.smt=ind0.smt, tab.ind.smt=tab.ind.smt,
                     beta.smt=beta.smt, alpha.smt=alpha.smt, ucb.new.smt=ucb.new.smt)
save(psmt.rs.list, file="c2.psmt.rs.list.RData")














